import type {ComponentProps} from "react";

const AppScreenshot = ({...props}: ComponentProps<"svg">) => (
  <svg
    className="aspect-[1115/768] w-full"
    fill="none"
    viewBox="80 50 1115 768"
    xmlns="http://www.w3.org/2000/svg"
    xmlnsXlink="http://www.w3.org/1999/xlink"
    {...props}
  >
    <g filter="url(#filter0_dddddd_3051_11417)">
      <g clipPath="url(#clip0_3051_11417)">
        <rect
          fill="url(#paint0_linear_3051_11417)"
          height="616"
          rx="12"
          width="1115"
          x="83"
          y="56"
        />
        <rect fill="white" fillOpacity="0.16" height="12" rx="6" width="12" x="103" y="76" />
        <rect fill="white" fillOpacity="0.16" height="12" rx="6" width="12" x="123" y="76" />
        <rect fill="white" fillOpacity="0.16" height="12" rx="6" width="12" x="143" y="76" />
        <rect fill="white" fillOpacity="0.1" height="32" rx="8" width="250" x="515" y="66" />
        <text
          dominantBaseline="middle"
          fill="white"
          fillOpacity="0.7"
          fontSize="13"
          textAnchor="middle"
          x="640"
          y="83"
        >
          heroui.pro
        </text>
        <path
          d="M527.481 87.332H532.514C533.33 87.332 533.754 86.897 533.754 86.0161V82.208C533.754 81.4346 533.421 81.0049 532.777 80.9189V79.6406C532.777 77.6587 531.466 76.6328 530 76.6328C528.534 76.6328 527.223 77.6587 527.223 79.6406V80.9189C526.579 81.0049 526.24 81.4346 526.24 82.208V86.0161C526.24 86.897 526.665 87.332 527.481 87.332ZM528.228 79.5439C528.228 78.2817 529.039 77.5942 530 77.5942C530.956 77.5942 531.772 78.2817 531.772 79.5439V80.8975H528.228V79.5439Z"
          fill="white"
          fillOpacity="0.6"
        />
        <g clipPath="url(#clip1_3051_11417)">
          <path
            d="M749.64 84.3788L750.53 83.4823C749.827 83.4179 749.335 83.1952 748.972 82.8319C747.981 81.8417 747.981 80.4355 748.966 79.4511L750.911 77.5058C751.901 76.5155 753.302 76.5155 754.292 77.5058C755.288 78.5077 755.282 79.9023 754.298 80.8866L753.29 81.8944C753.478 82.3222 753.536 82.8437 753.437 83.2948L755.118 81.619C756.56 80.1835 756.565 78.1444 755.112 76.6913C753.659 75.2323 751.62 75.244 750.185 76.6796L748.146 78.7245C746.71 80.1601 746.698 82.1991 748.151 83.6523C748.497 83.9921 748.96 84.2499 749.64 84.3788ZM750.155 79.4394L749.271 80.3358C749.968 80.4003 750.466 80.6288 750.823 80.9862C751.819 81.9823 751.819 83.3827 750.829 84.3671L748.884 86.3124C747.894 87.3026 746.499 87.3026 745.503 86.3124C744.507 85.3163 744.513 83.9159 745.503 82.9315L746.505 81.9237C746.323 81.496 746.259 80.9804 746.358 80.5233L744.683 82.1991C743.241 83.6347 743.235 85.6796 744.688 87.1327C746.142 88.5858 748.181 88.5741 749.616 87.1386L751.649 85.0995C753.091 83.6581 753.097 81.619 751.644 80.1718C751.304 79.8261 750.841 79.5683 750.155 79.4394Z"
            fill="white"
            fillOpacity="0.6"
          />
        </g>
        <path
          d="M178.492 89.0857H191.508C193.149 89.0857 194 88.2347 194 86.6163V77.3694C194 75.7434 193.149 74.9 191.508 74.9H178.492C176.851 74.9 176 75.7434 176 77.3694V86.6163C176 88.2423 176.851 89.0857 178.492 89.0857ZM178.583 87.5965C177.877 87.5965 177.489 87.2242 177.489 86.4872V77.491C177.489 76.7539 177.877 76.3892 178.583 76.3892H182.041V87.5965H178.583ZM191.417 76.3892C192.116 76.3892 192.511 76.7539 192.511 77.491V86.4872C192.511 87.2242 192.116 87.5965 191.417 87.5965H183.454V76.3892H191.417ZM180.551 79.1702C180.817 79.1702 181.045 78.9422 181.045 78.6839C181.045 78.4255 180.817 78.2052 180.551 78.2052H178.994C178.72 78.2052 178.492 78.4255 178.492 78.6839C178.492 78.9422 178.72 79.1702 178.994 79.1702H180.551ZM180.551 81.2065C180.817 81.2065 181.045 80.9785 181.045 80.7202C181.045 80.4618 180.817 80.2415 180.551 80.2415H178.994C178.72 80.2415 178.492 80.4618 178.492 80.7202C178.492 80.9785 178.72 81.2065 178.994 81.2065H180.551ZM180.551 83.2352C180.817 83.2352 181.045 83.0148 181.045 82.7565C181.045 82.4981 180.817 82.2778 180.551 82.2778H178.994C178.72 82.2778 178.492 82.4981 178.492 82.7565C178.492 83.0148 178.72 83.2352 178.994 83.2352H180.551Z"
          fill="white"
          fillOpacity="0.6"
        />
        <path
          d="M229.6 82.3516C229.6 82.5859 229.702 82.8125 229.881 82.9844L235.03 88.1328C235.217 88.3125 235.428 88.3984 235.639 88.3984C236.131 88.3984 236.483 88.0469 236.483 87.5781C236.483 87.3359 236.389 87.125 236.233 86.9766L234.483 85.2031L232.17 83.0938L233.999 83.2031H243.499C244.006 83.2031 244.366 82.8516 244.366 82.3516C244.366 81.8438 244.006 81.5 243.499 81.5H233.999L232.178 81.6094L234.483 79.5L236.233 77.7266C236.389 77.5703 236.483 77.3594 236.483 77.1172C236.483 76.6484 236.131 76.3047 235.639 76.3047C235.428 76.3047 235.217 76.3828 235.014 76.5781L229.881 81.7188C229.702 81.8828 229.6 82.1172 229.6 82.3516Z"
          fill="white"
          fillOpacity="0.6"
        />
        <path
          d="M280.366 82.3516C280.366 82.1172 280.264 81.8828 280.084 81.7188L274.944 76.5781C274.749 76.3828 274.538 76.3047 274.319 76.3047C273.834 76.3047 273.483 76.6484 273.483 77.1172C273.483 77.3594 273.577 77.5703 273.733 77.7266L275.483 79.5L277.78 81.6094L275.967 81.5H266.467C265.952 81.5 265.6 81.8438 265.6 82.3516C265.6 82.8516 265.952 83.2031 266.467 83.2031H275.967L277.788 83.0938L275.483 85.2031L273.733 86.9766C273.577 87.125 273.483 87.3359 273.483 87.5781C273.483 88.0469 273.834 88.3984 274.319 88.3984C274.538 88.3984 274.741 88.3125 274.928 88.1328L280.084 82.9844C280.264 82.8125 280.366 82.5859 280.366 82.3516Z"
          fill="white"
          fillOpacity="0.2"
        />
        <path
          d="M302 82.9141C302 86.7891 305.109 89.9062 308.977 89.9062C312.844 89.9062 315.953 86.7891 315.953 82.9141C315.953 82.4531 315.633 82.125 315.172 82.125C314.727 82.125 314.43 82.4531 314.43 82.9141C314.43 85.9453 312 88.375 308.977 88.375C305.953 88.375 303.531 85.9453 303.531 82.9141C303.531 79.8672 305.938 77.4531 308.953 77.4531C309.469 77.4531 309.945 77.4922 310.344 77.5781L308.219 79.6875C308.078 79.8359 308.008 80 308.008 80.2031C308.008 80.6328 308.328 80.9609 308.75 80.9609C308.969 80.9609 309.148 80.8906 309.281 80.75L312.492 77.5156C312.656 77.3516 312.734 77.1641 312.734 76.9531C312.734 76.75 312.648 76.5469 312.492 76.3906L309.281 73.1328C309.148 72.9844 308.969 72.9062 308.75 72.9062C308.328 72.9062 308.008 73.25 308.008 73.6719C308.008 73.875 308.078 74.0547 308.211 74.1953L310.102 76.0625C309.758 75.9922 309.359 75.9531 308.953 75.9531C305.094 75.9531 302 79.0469 302 82.9141Z"
          fill="white"
          fillOpacity="0.6"
        />
        <path
          d="M1161.15 82.0068C1161.15 82.4136 1161.49 82.7456 1161.89 82.7456H1167.26V88.1162C1167.26 88.5146 1167.59 88.855 1168 88.855C1168.41 88.855 1168.75 88.5146 1168.75 88.1162V82.7456H1174.11C1174.51 82.7456 1174.85 82.4136 1174.85 82.0068C1174.85 81.6001 1174.51 81.2598 1174.11 81.2598H1168.75V75.8975C1168.75 75.499 1168.41 75.1587 1168 75.1587C1167.59 75.1587 1167.26 75.499 1167.26 75.8975V81.2598H1161.89C1161.49 81.2598 1161.15 81.6001 1161.15 82.0068Z"
          fill="white"
          fillOpacity="0.6"
        />
        <path
          d="M1132 90.4736C1136.63 90.4736 1140.47 86.6304 1140.47 82.0068C1140.47 77.375 1136.62 73.54 1131.99 73.54C1127.37 73.54 1123.53 77.375 1123.53 82.0068C1123.53 86.6304 1127.38 90.4736 1132 90.4736ZM1132 89.0625C1128.08 89.0625 1124.95 85.9248 1124.95 82.0068C1124.95 78.0889 1128.07 74.9512 1131.99 74.9512C1135.91 74.9512 1139.06 78.0889 1139.06 82.0068C1139.06 85.9248 1135.92 89.0625 1132 89.0625ZM1132 77.7817C1131.64 77.7817 1131.38 78.0391 1131.38 78.4043V82.5547L1131.44 84.3062L1130.61 83.3101L1129.63 82.314C1129.51 82.1978 1129.36 82.1313 1129.19 82.1313C1128.85 82.1313 1128.59 82.3887 1128.59 82.729C1128.59 82.9033 1128.64 83.0527 1128.75 83.1606L1131.52 85.9165C1131.68 86.0825 1131.83 86.1572 1132 86.1572C1132.18 86.1572 1132.33 86.0742 1132.49 85.9165L1135.25 83.1606C1135.36 83.0527 1135.43 82.9033 1135.43 82.729C1135.43 82.3887 1135.16 82.1313 1134.82 82.1313C1134.64 82.1313 1134.49 82.1895 1134.38 82.314L1133.4 83.3101L1132.56 84.3145L1132.62 82.5547V78.4043C1132.62 78.0391 1132.37 77.7817 1132 77.7817Z"
          fill="white"
          fillOpacity="0.6"
        />
        <rect fill="black" height="906" transform="translate(83 108)" width="1115" />
        <g filter="url(#filter1_ddd_3051_11417)">
          <rect fill="url(#pattern0_3051_11417)" height="702.001" width="1099" x="91" y="116" />
        </g>
      </g>
      <rect
        height="761"
        rx="11.5"
        stroke="white"
        strokeOpacity="0.1"
        width="1111"
        x="83.5"
        y="56.5"
      />
    </g>
    <defs>
      <filter
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
        height="830"
        id="filter0_dddddd_3051_11417"
        width="1329"
        x="-24"
        y="0"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy="1.4113" />
        <feGaussianBlur stdDeviation="1.48048" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.176471 0 0 0 0 0.188235 0 0 0 0 0.223529 0 0 0 0.0253031 0"
        />
        <feBlend in2="BackgroundImageFix" mode="normal" result="effect1_dropShadow_3051_11417" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy="3.39155" />
        <feGaussianBlur stdDeviation="3.5578" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.176471 0 0 0 0 0.188235 0 0 0 0 0.223529 0 0 0 0.0363503 0"
        />
        <feBlend
          in2="effect1_dropShadow_3051_11417"
          mode="normal"
          result="effect2_dropShadow_3051_11417"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy="6.38599" />
        <feGaussianBlur stdDeviation="6.69903" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.176471 0 0 0 0 0.188235 0 0 0 0 0.223529 0 0 0 0.045 0"
        />
        <feBlend
          in2="effect2_dropShadow_3051_11417"
          mode="normal"
          result="effect3_dropShadow_3051_11417"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy="11.3915" />
        <feGaussianBlur stdDeviation="11.9499" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.176471 0 0 0 0 0.188235 0 0 0 0 0.223529 0 0 0 0.0536497 0"
        />
        <feBlend
          in2="effect3_dropShadow_3051_11417"
          mode="normal"
          result="effect4_dropShadow_3051_11417"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy="21.3066" />
        <feGaussianBlur stdDeviation="22.351" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.176471 0 0 0 0 0.188235 0 0 0 0 0.223529 0 0 0 0.0646969 0"
        />
        <feBlend
          in2="effect4_dropShadow_3051_11417"
          mode="normal"
          result="effect5_dropShadow_3051_11417"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy="51" />
        <feGaussianBlur stdDeviation="53.5" />
        <feColorMatrix
          type="matrix"
          values="0 0 0 0 0.176471 0 0 0 0 0.188235 0 0 0 0 0.223529 0 0 0 0.09 0"
        />
        <feBlend
          in2="effect5_dropShadow_3051_11417"
          mode="normal"
          result="effect6_dropShadow_3051_11417"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect6_dropShadow_3051_11417"
          mode="normal"
          result="shape"
        />
      </filter>
      <filter
        colorInterpolationFilters="sRGB"
        filterUnits="userSpaceOnUse"
        height="902"
        id="filter1_ddd_3051_11417"
        width="1111"
        x="85"
        y="110"
      >
        <feFlood floodOpacity="0" result="BackgroundImageFix" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy="2" />
        <feGaussianBlur stdDeviation="2" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0" />
        <feBlend in2="BackgroundImageFix" mode="normal" result="effect1_dropShadow_3051_11417" />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset dy="1" />
        <feGaussianBlur stdDeviation="0.5" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.06 0" />
        <feBlend
          in2="effect1_dropShadow_3051_11417"
          mode="normal"
          result="effect2_dropShadow_3051_11417"
        />
        <feColorMatrix
          in="SourceAlpha"
          result="hardAlpha"
          type="matrix"
          values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0"
        />
        <feOffset />
        <feGaussianBlur stdDeviation="3" />
        <feComposite in2="hardAlpha" operator="out" />
        <feColorMatrix type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.1 0" />
        <feBlend
          in2="effect2_dropShadow_3051_11417"
          mode="normal"
          result="effect3_dropShadow_3051_11417"
        />
        <feBlend
          in="SourceGraphic"
          in2="effect3_dropShadow_3051_11417"
          mode="normal"
          result="shape"
        />
      </filter>
      <pattern
        height="1"
        id="pattern0_3051_11417"
        patternContentUnits="objectBoundingBox"
        width="1"
      >
        <use transform="scale(0.000251383 0.000393546)" xlinkHref="#image0_3051_11417" />
      </pattern>
      <linearGradient
        gradientUnits="userSpaceOnUse"
        id="paint0_linear_3051_11417"
        x1="83"
        x2="1201.48"
        y1="56"
        y2="55.9999"
      >
        <stop stopColor="#242424" />
        <stop offset="1" />
      </linearGradient>
      <image
        height="2500"
        id="image0_3051_11417"
        width="3978"
        xlinkHref="https://nextuipro.nyc3.cdn.digitaloceanspaces.com/components-images/marketing/hero-section-with-bottom-app-screenshot.png"
      />
    </defs>
  </svg>
);

export default AppScreenshot;
